 ; Ŀ
 ;   Tork - derotate an ss of text/attdefs around their common centre      
 ;   point if they aren't at an acceptable angle.                          
 ;   Copyright 2003, 2010 by Rocket Software Ltd.                          
 ;                                                                         
 ; 

 ; Ŀ
 ;   Bock: find the box bounding the selection set of text or attdef       
 ;   entities which is passed as the sole argument.                        
 ; 
 (DEFUN BOCK (ss / num enam typ entt mxlst xmax xmin ymax ymin pl)
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (grtext -2 (itoa (setq num (1+ num))))
         (setq typ (cdr (assoc 0 (entget enam))))
         (setq mxlst (cron enam 0))
         (if xmax
             (setq xmax (max xmax (car mxlst)))
             (setq xmax (car mxlst)))
         (if xmin
             (setq xmin (min xmin (cadr mxlst)))
             (setq xmin (cadr mxlst)))
         (if ymax
             (setq ymax (max ymax (caddr mxlst)))
             (setq ymax (caddr mxlst)))
         (if ymin
             (setq ymin (min ymin (cadddr mxlst)))
             (setq ymin (cadddr mxlst))))
  (list (list xmin ymin) (list xmax ymax)))
 ; Ŀ
 ;   Bock end.                                                             
 ; 

 ; Ŀ
 ;   Cron - returns the corners of a text entity.                          
 ;   Arguments: Enam, a text entity ename.                                 
 ;              Offdis, the offset distance.                               
 ;   Rewritten 2010.10.10.                                                 
 ; 
 (DEFUN CRON (enam offdis / aa bb rota cc dd bheigt bwidth llangg lldist ll ul
                                                    lr ur xmax xmin ymax ymin)
  (setq aa (entget enam))
 ; Ŀ
 ;   The textbox function returns...hang on...from the notes below, a      
 ;   list containing the offset of the lower left point of the text from   
 ;   the 10 association point - typically 0,0,0 - and the offset of the    
 ;   upper right point from the ten point.  These are assumining that the  
 ;   text isn't obliqued or rotated, so if it is the program must adjust   
 ;   accordingly.  This program won't bother with obliquing, rotation is   
 ;   allowed.                                                              
 ; 
  (setq bb (textbox aa))
  (setq rota (cdr (assoc 50 aa)))
  (setq cc (car bb))                    ; ll offset from 10 of text
  (setq dd (cadr bb))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
 ; Ŀ
 ;   Extract the real corner points of the text.                           
 ; 
  (setq ll (polar (cdr (assoc 10 aa)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   Find the maximum and minimum X and Y points.  These may not be the    
 ;   same as the corners of the text box, since the text may be rotated.   
 ; 
  (setq xmax (max (car ul) (car ll) (car ur) (car lr)))
  (setq xmin (min (car ul) (car ll) (car ur) (car lr)))
  (setq ymax (max (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq ymin (min (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq xmax (+ xmax offdis))
  (setq xmin (- xmin offdis))
  (setq ymax (+ ymax offdis))
  (setq ymin (- ymin offdis))
 ; Ŀ
 ;   And return the max and min x and y list.                              
 ; 
 (list xmax xmin ymax ymin))
 ; Ŀ
 ;   Cron end.                                                             
 ; 

 ; Ŀ
 ;   Tork - the central planning committee.                                
 ; 
 (DEFUN C:TORK (/ ss pts ll ur pa)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (write-line "Select text to rotate: ")
  (setq ss (ssget '((-4 . "<or") (0 . "text") (0 . "attdef") (-4 . "or>"))))
  (if (and ss
           (setq entt (entget (ssname ss 0)))
           (setq ang1 (cdr (assoc 50 entt)))
 ; Ŀ
 ;   If text isn't horizontal make it so.                                  
 ; 
           (/= ang1 0))
      (progn
           (setq pts (bock ss))
           (setq ll (car pts))
           (setq ur (cadr pts))
           (grdraw ll ll 2)
           (grdraw ur ur 2)
           (setq pa (polar ll (angle ll ur) (/ (distance ll ur) 2.0)))
 ; Ŀ
 ;   Decide how much rotation is needed.                                   
 ; 
           (setq rotap (- (/ (* ang1 180) pi)))
           (command "rotate" ss "" pa rotap)))
  (command "undo" "end")
 (princ))